#include <iostream>
#include <vector>
#include <algorithm>
#include <numeric>

using namespace std;

// Function to find the index of the maximum element in a row vector
int findMaxRow(const vector<int>& rowVector) {
    int maxIndex = 0;
    int maxValue = rowVector[0];

    for (int i = 1; i < rowVector.size(); i++) {
        if (rowVector[i] > maxValue) {
            maxValue = rowVector[i];
            maxIndex = i;
        }
    }

    return maxIndex;
}

// Function to swap the maximum element with the middle element in a row vector
void swapMaxWithMiddle(vector<int>& rowVector) {
    int middleIndex = rowVector.size() / 2;
    int maxIndex = findMaxRow(rowVector);

    if (maxIndex != middleIndex) {
        swap(rowVector[middleIndex], rowVector[maxIndex]);
    }
}

// Function to sort a row vector such that the maximum element is at the middle
void sortRow(vector<int>& rowVector) {
    int middleIndex = rowVector.size() / 2;
    swapMaxWithMiddle(rowVector);
    sort(rowVector.begin(), rowVector.end());
}

// Function to partition the matrix into submatrices of size KxL
void partitionMatrix(const vector<vector<int>>& matrix, int K, int L, vector<vector<vector>>& submatrices) {
    int numRows = matrix.size();
    int numCols = matrix[0].size();

    for (int i = 0; i < numRows - K + 1; i++) {
        for (int j = 0; j < numCols - L + 1; j++) {
            submatrices.push_back(vector<vector>(K, vector<int>(L)));

            for (int k = 0; k < K; k++) {
                for (int l = 0; l < L; l++) {
                    submatrices[i + k][j + l][k * L + l] = matrix[i + k][j + l];
                }
            }